VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Measure Frequency from 77xx Channels"
   ClientHeight    =   4800
   ClientLeft      =   2805
   ClientTop       =   1650
   ClientWidth     =   6030
   LinkTopic       =   "Form1"
   ScaleHeight     =   4800
   ScaleWidth      =   6030
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Session"
      Height          =   375
      Left            =   600
      TabIndex        =   6
      Top             =   840
      Width           =   1575
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "OK"
      Height          =   615
      Left            =   4800
      TabIndex        =   5
      Top             =   3960
      Width           =   855
   End
   Begin VB.CommandButton cmdReadRange 
      Caption         =   "VAC Range Used for Freq"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   3
      Top             =   3240
      Width           =   2055
   End
   Begin VB.ListBox List1 
      Height          =   1230
      Left            =   2640
      TabIndex        =   2
      Top             =   960
      Width           =   1575
   End
   Begin VB.CommandButton cmdRun 
      Caption         =   "Measure Channels 101 and 102"
      Enabled         =   0   'False
      Height          =   615
      Left            =   600
      TabIndex        =   0
      Top             =   1440
      Width           =   1575
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   480
      TabIndex        =   7
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label lblResponse 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   2880
      TabIndex        =   4
      Top             =   3240
      Width           =   975
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   495
      Left            =   480
      TabIndex        =   1
      Top             =   2400
      Width           =   4935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' this example was tested in VB6 in Win2K SP4
' using IVI driver Version 2700-852B01.3
' with a 2700 FW B06 and a 7700 card in slot 1
'
'
Option Explicit
Dim vi As ViSession
Dim status As ViStatus
Dim readingArray(50) As ViReal64
Dim arraySize As ViInt32, maxTime As ViInt32, actualPts As ViInt32
' Uncomment or redefine one of the following lines to select
' other communication bus types

' For RS-232 bus COM2
'Private Const InstrumentName = "ASRL2::INSTR"

' For GPIB bus,
'Private Const InstrumentName = "GPIB0::16::INSTR"

' For RS-232 bus COM1
Private Const InstrumentName = "ASRL1::INSTR"

Private Sub cmdExit_Click()
CloseDevice vi
End
End Sub

Private Sub cmdInit_Click()
 On Error GoTo Errorhandler
  lblStatus.Caption = "Trying to open session for " & InstrumentName
  DoEvents
  
    vi = OpenDevice
    
    cmdRun.Enabled = True
   
  Exit Sub

Errorhandler:
  If Err.Number <> 0 Then
    lblStatus.Caption = Err.Description
  End If
  CloseDevice vi
  'lblStatus.Caption = "Done"
End Sub

Private Sub cmdRun_Click()

  On Error GoTo Errorhandler
  
     ' Assumes a plug-in model in solt 1 and the INPUT switch at 'R' position
     lblStatus.Caption = "Setting up the Scan...."
     DoEvents
 
 ' Configure channels 101 and 102 for Frequency
  CheckError vi, KE2700_ConfigureMeasurement(KE2700_ChannelList(vi, "101:102"), _
                                             KE2700_VAL_FREQ, _
                                             KE2700_VAL_AUTO_RANGE_ON, _
                                             100)
 ' set attribute for number of digits to use
  CheckError vi, KE2700_SetAttributeViReal64(vi, _
                                            "101:102", _
                                            KE2700_ATTR_RESOLUTION_ABSOLUTE, _
                                            0.1)  ' last param is the resolution to use
 ' 0.001 = FREQ:DIG 7
 ' 0.010 = FREQ:DIG 6
 ' 0.100 = FREQ:DIG 5
 ' 1.000 = FREQ:DIG 4
 
 ' Configure trigger
  CheckError vi, KE2700_ConfigureTrigger(vi, KE2700_VAL_IMMEDIATE, 0.01)
 ' Configure trigger count, sample count, trigger source, Scan List
 Dim SampleCount As Integer
 SampleCount = 4  ' needs to be multiple of how many channels
  CheckError vi, KE2700_ConfigureMultiPoint(KE2700_ChannelList(vi, "101:102"), 1, _
                                            SampleCount, _
                                            KE2700_VAL_IMMEDIATE, 0#)
 ' Initiate the scan
  CheckError vi, KE2700_Initiate(vi)
 ' Wait and Fetch the readings
  arraySize = 50: maxTime = 60000: actualPts = 0
  CheckError vi, KE2700_FetchMultiPoint(vi, maxTime, arraySize, readingArray(0), actualPts)
   
 List1.Clear
 Dim i As Integer
 For i = 0 To SampleCount - 1
 List1.AddItem Format(Str(readingArray(i)), "##.##0"), i
 Next i
  
  
  lblStatus.Caption = "Done"
  cmdReadRange.Enabled = True
  Exit Sub

Errorhandler:
  If Err.Number <> 0 Then
    lblStatus.Caption = Err.Description
  End If
  'CloseDevice vi
  'lblStatus.Caption = "Done"
End Sub

' Routine:
'   OpenDevice

' Purpose:
'   Opens a physical or simulated instrument.
'   Define InstrumentName const to select instrument.
'   Define Simulate const to select physical or simulated instrument.

' Return:
'   VISA instrument session handle

' Exception:
'   If OpenDevice fails, it throws error to caller using CheckError

Public Function OpenDevice() As ViSession
 
  status = KE2700_InitWithOptions(InstrumentName, VI_TRUE, _
                                  VI_TRUE, _
                                  "Simulate=0,RangeCheck=1,QueryInstrStatus=1,Cache=1", _
                                  vi)
  OpenDevice = vi
  CheckError vi, status
End Function

' Routine:
'   CloseDevice

' Purpose:
'   Closes a previously opened instrument

' Return:
'   None

' Exception:
'   If CloseDevice fails, it throws error to caller using CheckError

Public Sub CloseDevice(ByVal vi As ViSession)
  Dim Error As ViStatus
  Error = VI_SUCCESS
  If vi <> 0 Then Error = KE2700_close(vi)
  CheckError vi, Error
End Sub



' Routine:
'   CheckError

' Purpose:
'   This routine checks the return value of the given IVI function call.
'   It constructs an error message if an error occurs.

'   If the ErrorCode is greater than &HBFFF0000, then the error is reported by the IVI
'   Driver, otherwise, it's reported directly from the hardware instrument.
'   For errors reported by IVI Driver, use KE2700_error_message to retrieve the error code.
'   For errors reported by instruments, use KE2700_query_error

' Return:
'  None

' Exception:
'   If <ErrorCode> does indicate an error condition, then a constructed error is raised
'   to the caller.

Public Sub CheckError(ByVal vi As ViSession, ByVal ErrorCode As ViStatus)
  Dim ErrMsg As String
  Dim buffer As String
  Dim ErrCode As ViStatus
  Dim PrimaryErr As ViStatus
  Dim SecondaryErr As ViStatus
  Dim ElaborationErr As String

  If ErrorCode = VI_SUCCESS Then Exit Sub
  ErrMsg = ErrMsg & "Primary Error: (Hex " & Hex(ErrorCode) & ")" & vbCrLf
  buffer = Space$(256)

  If ErrorCode <> &HBFFA0001 Then ' IVI_ERROR_INSTR_SPECIFIC =  &HBFFA0001
    ' Error reported by IVI Driver
    KE2700_error_message vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
    KE2700_GetErrorInfo vi, PrimaryErr, SecondaryErr, ElaborationErr
  
    If PrimaryErr = ErrorCode And SecondaryErr <> 0 Then
      ' Check secondary error if there is any
      ErrMsg = ErrMsg & "Secondary Error: (Hex " & Hex(SecondaryErr) & ")" & vbCrLf
      KE2700_error_message vi, SecondaryErr, buffer
      ErrMsg = ErrMsg & Trim$(buffer)
      ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
      ' Check Elaboration error if there is any
      If Len(ElaborationErr) Then
        ErrMsg = ErrMsg & "Elaboration: " & ElaborationErr
      End If
    End If

  Else
    ' Error reported by instrument.
    KE2700_error_query vi, ErrorCode, buffer
    ErrMsg = ErrMsg & Trim$(buffer)
    ErrMsg = Left(ErrMsg, Len(ErrMsg) - 1) & vbCrLf
  End If

  'if not a warning, Raise error to the caller
  If ErrorCode < 0 Then Err.Raise ErrorCode, "IVI Driver Examples", ErrMsg
End Sub

Private Sub cmdReadRange_Click()
'CheckError vi, KE2700_WriteInstrData(vi, txtCmd.Text)

'Dim BytesRead As ViInt32
'Dim ReadBuffer As String * 50  'ViChar no defined for VB

'CheckError vi, KE2700_ReadInstrData(vi, 500, ReadBuffer, BytesRead)



Dim theValue As ViReal64
Dim channelName As String * 10

channelName = ""

CheckError vi, KE2700_GetAttributeViReal64(vi, _
                                          "101", _
                                          KE2700_ATTR_FREQ_VOLTAGE_RANGE, _
                                          theValue)
lblResponse.Caption = theValue

End Sub

